#include <cassert>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <algorithm>
#include <iostream>
#include <set>
#include <map>
#include <vector>
#include <queue>
#include <deque>
using namespace std;
#define pb push_back
#define mp make_pair
#define fs first
#define sc second
#define sz(a) ((int) (a).size())
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#define int64 long long
#define ldb long double
const double pi = acos(-1.0);
const int N = 40;
vector<int> vadd[N];
int64 adj[N];
int color[N], n, k[N];
bool colored;

struct pt {
	int x, y;
	pt() {}
	pt(int x, int y): x(x), y(y) {}
} p[N][N];

pt operator-(const pt& a, const pt& b) {
	return pt(a.x - b.x, a.y - b.y);
}

bool dfs(int v) {
	for (int i = 0; i < sz(vadd[v]); ++i) {
		int u = vadd[v][i];
		if (color[u] == 2) continue;
		else if (color[u] == -1) {
			color[u] = (color[v] ^ 1);
			if (!dfs(u)) return false;
		} else if (color[u] != (color[v] ^ 1))
			return false;
	}
	return true;
}

void bicolor() {
	for (int i = 0; i < n; ++i)
		if (color[i] == -1) {
			color[i] = 0;
			if (!dfs(i)) return;
		}
	colored = true;
}

void restore(int64 mask) {
	for (int i = 0; i < n; ++i)
		if (!((mask >> i) & 1)) color[i] = -1;
}

void go(int v, int64 mask, int64 forbidden) {
	if (v == n) {
		bicolor();
		if (colored) return;
		restore(mask);
		return;
	}
	if (((mask >> v) & 1) || ((forbidden >> v) & 1)) {
		go(v + 1, mask, forbidden);
		return;
	}
	color[v] = 2;
	go(v + 1, mask | (1LL << v), forbidden | adj[v]);
	if (colored) return;
	color[v] = -1;
	int64 good_mask = (adj[v] & (~forbidden));
	if (mask & good_mask) {
		go(v + 1, mask, forbidden | (1LL << v));
		return;
	}
	for (int i = 0; i < sz(vadd[i]); ++i) {
		int u = vadd[v][i];
		if (((mask | forbidden) >> u) & 1) continue;
		go(v, mask | (1 << u), forbidden);
		if (colored) return;
		forbidden |= (1 << u);
	}
}

int vmul(const pt& a, const pt& b) {
	return a.x * b.y - a.y * b.x;
}

int smul(const pt& a, const pt& b) {
	return a.x * b.x + a.y * b.y;
}

bool share(const pt& a, const pt& b, const pt& c, const pt& d) {
	pt v = b - a;
	if ((vmul(v, d - c) != 0) || (vmul(v, d - a) != 0)) return false;
	int ca = 0, cb = smul(v, b - a), cc = smul(v, c - a), cd = smul(v, d - a);
	if (cc > cd) swap(cc, cd);
	return max(ca, cc) < min(cb, cd);
}

int main() {
	assert(freopen("input.txt", "r", stdin));
	assert(freopen("output.txt", "w", stdout));
	while ((scanf("%d", &n) == 1) && (n > 0)) {
		for (int i = 0; i < n; ++i) {
			scanf("%d", &k[i]);
			for (int j = 0; j < k[i]; ++j)
				scanf("%d%d", &p[i][j].x, &p[i][j].y);
			p[i][k[i]] = p[i][0], adj[i] = 0, color[i] = -1, vadd[i].clear();
		}
		colored = true;
		for (int i = 0; i < n; ++i)
			for (int j = i + 1; j < n; ++j) {
				bool done = false;
				for (int e1 = 0; (e1 < k[i]) && !done; ++e1)
					for (int e2 = 0; e2 < k[j]; ++e2)
						if (share(p[i][e1], p[i][e1 + 1], p[j][e2], p[j][e2 + 1])) {
							done = true;
							break;
						}
				if (done) {
					colored = false;
					adj[i] |= (1LL << j);
					adj[j] |= (1LL << i);
					vadd[i].pb(j);
					vadd[j].pb(i);
				}
			}
		if (colored) {
			printf("1\n");
			continue;
		}
		bicolor();
		restore(0);
		if (colored) {
			printf("2\n");
			continue;
		}
		bool kill = false;
		for (int i = 0; i < n; ++i)
			for (int j = 0; j < n; ++j)
				if ((adj[i] >> j) & 1)
					for (int k = 0; k < n; ++k)
						if (((adj[i] >> k) & 1) && ((adj[j] >> k) & 1)) {
							int x = (adj[i] & adj[j] & adj[k]);
							if (x != 0) {
								kill = true;
								break;
							}
						}
		if (kill) {
			printf("4\n");
			continue;
		}
		go(0, 0, 0);
		if (colored) {
			for (int i = 0; i < n; ++i)
				for (int j = 0; j < sz(vadd[i]); ++j)
					assert(color[i] != color[vadd[i][j]]);
		}
		printf("%d\n", colored ? 3 : 4);
	}
	return 0;
}